// Summary statistics for meeting based variables
clear

// pick the folder for data:
cd "D:\Projects\Brookings 2015\Taylor Rules\Data"
//cd "C:\Users\g1tjs01\Documents\brookings\1987 extension\files for final submission"

// set to 0 to use all forecasters; 1 to use only forecasters with at least 4 bins.
local x 0 

// load data
use meetingData

// Create quarter variable
gen strfomc = fomcdate
format %16.0f strfomc
gen strdate = string(strfomc, "%16.0f")
gen date = date(strdate, "YMD")
format date %td
drop strfomc strdate
gen fomcquarter = quarter(date)

tsset proxy_time

destring uncertlevel, replace

// define variables for taylor rule estimation
gen corecpi_4q = (corecpi_T0 + corecpi_T1 + corecpi_T2 + corecpi_T3 )/4
gen outputgap_4q = (outputgap_T0 + outputgap_T1 + outputgap_T2 + outputgap_T3)/4
gen ffr = ffraftermeeting

// gap revision
gen outputgap_4q_TM1 = (L.outputgap_T1 + L.outputgap_T2 + L.outputgap_T3 + L.outputgap_T4)/4 if fomcquarter != L.fomcquarter
replace outputgap_4q_TM1 = (L.outputgap_T0 + L.outputgap_T1 + L.outputgap_T2 + L.outputgap_T3)/4 if fomcquarter == L.fomcquarter
gen gap_revision = outputgap_4q-outputgap_4q_TM1

// corecpi revision
gen corecpi_4q_TM1 = (L.corecpi_T1 + L.corecpi_T2 + L.corecpi_T3 + L.corecpi_T4)/4 if fomcquarter != L.fomcquarter
replace corecpi_4q_TM1 = (L.corecpi_T0 + L.corecpi_T1 + L.corecpi_T2 + L.corecpi_T3)/4 if fomcquarter == L.fomcquarter
gen corecpi_revision = corecpi_4q - corecpi_4q_TM1

// other fomc variables
// word counts
gen wordunc = 100*(mp_cond_uncertaintyactivity+mp_cond_uncertaintyinflation)
gen wordins = 100*(mp_cond_insuranceactivity+mp_cond_insuranceinflation)

label variable ffr "FFR"
label variable corecpi_4q "Four-quarter inflation average"
label variable outputgap_4q "Four-quarter output gap average"

// Rename variables so tables have right variable names
gen hUnc = uncertlevel
gen hIns = insurlevel
gen mUnc = wordunc
gen mIns = wordins
gen frGap = gap_revision
gen frInf = corecpi_revision
gen fcGap = outputgap_4q
gen fcInf = corecpi_4q

// Label variables (note that some variables are renamed duplicates)
label var date "date"
label var fomcquarter "Quarter in which the FOMC meeting was held"
label var hUnc "Uncertainty indicator for FOMC minutes"
label var hIns "Insurance indicator for FOMC minutes"
label var mUnc "Sum of inflation and activity uncertainty word count percentages"
label var mIns "Sum of inflation and activity insurance word count percentages"
label var frGap "Difference between actual and revised output gap"
label var frInf "Difference between actual and revised core CPI"
label var fcGap "Four-quarter output gap average"
label var fcInf "Four-quarter core CPI average"
label var outputgap_4q_TM1 "Lagged output gap"
label var corecpi_4q_TM1 "Lagged core CPI"
label var corecpi_revision "Difference between actual and revised core CPI"
label var gap_revision "Difference between actual and revised output gap"
label var wordunc "Sum of inflation and activity uncertainty word count percentages"
label var wordins "Sum of inflation and activity insurance word count percentages"


// Summary statistics: Input for Tables 4 and 6

// pick the directory for output
//cd "C:\Users\g1tjs01\Documents\brookings\1987 extension\files for final submission\output"
cd "C:\swp55\Docs\Brookings 2015\Tables"

sutex   fcInf fcGap hUnc hIns mUnc mIns frInf frGap if proxy_time>=1048, dig(2) minmax file("sum_stats_minutes") replace
corrtex fcInf fcGap hUnc hIns mUnc mIns frInf frGap if proxy_time>=1048, dig(2) file("corr_stats_minutes") replace

